import pylightxl.pylightxl as xl
from typing import List, Tuple

from dbAPI import dbAPI
from customTypes import getStringsFromDayHour


class InsegnamentoJotForm:
    def __init__(self, row) -> None:
        self.dbAPI = dbAPI()
        self.titolo:str = row[2]
        self.titolare:str = str(row[3]).title()
        self.preferenze:List[str] = ['']*35
        for j in range(7):
            for i in range(5,5+5):
                # if row[i+j*5] != "":
                self.preferenze[(i-5)*7+j] = row[i+j*5]
        self.indispDidattica:str = row[40]
        self.note:str = row[41]
        self.conflitti:str = row[42]
        self.noteAggiuntive:str = row[42]
        
    def __str__(self)->str:
        return self.titolare + " - " + self.titolo
        
    def valid(self) -> bool:
        docs = self.dbAPI.get_Docenti()
        listDoc:List[str] = list(map(lambda row: row[0], docs))
        if self.titolare not in listDoc:
            return False        
        if self.titolo == "" or self.titolare == "":
            return False
        return True
        
    def checkStrange(self) -> bool:
        if self.titolare == "Poncino Massimo":
            return False
        nIndisp:int = 0
        nNonGradito:int = 0
        nGradito:int = 0
        for slot in self.preferenze:
            if slot == "Indisponibile":
                nIndisp += 1
            elif slot == "Non Gradito":
                nNonGradito += 1
            elif slot == "Gradito":
                nGradito += 1
        if nIndisp > 5:
            return True
        return False



class JotFormReader:
    def __init__(self, fileJotFormPath:str) -> None:
        self.fileExcel = xl.readxl(fn=fileJotFormPath)
        self.sheet = self.fileExcel.ws(ws="Sheet1")
        self.listIns:List[InsegnamentoJotForm] = list()
        
    def loadIndisponibilita(self):
        lineHeader = True
        for row in self.sheet.rows:
            if lineHeader:
                lineHeader = False
                continue
            i = InsegnamentoJotForm(row)
            if i.valid():
                self.listIns.append(i)
            else:
                print("WARN: record invalido: " + str(i))
            
    def debug(self):
        for slot in self.listIns[0].preferenze:
            print(slot)
            
    def sort(self):
        # prepare stuff for sorting
        unsortedIdList:List[Tuple[str,str]] = list()
        for ins in self.listIns:
            idIns = ins.titolare + "-" + ins.titolo
            unsortedIdList.append((idIns, ins.titolare))
        sortedIdList:List[Tuple[str,str]] = list()
        sortedIdList = sorted(unsortedIdList, key=lambda tup: tup[1])
        
        newListIns:List[InsegnamentoJotForm] = list()

        for item in sortedIdList:
            titolare:str = item[0].split("-")[0]
            titolo:str = item[0].split("-")[1]
            found:bool = False
            for ins in self.listIns:
                if ins.titolare == titolare and ins.titolo == titolo:
                    if found:
                        print("WARN - doppione:" + ins.titolare + " - " + ins.titolo)
                        continue
                    found = True
                    newListIns.append(ins)
        self.listIns = newListIns     
            
    def printResults(self):
        for ins in self.listIns:
            if ins.checkStrange():
                print(ins.titolare + " - " + ins.titolo)
                print("WARN - Troppe preferenze inserite")
                for i in range(5):
                    for j in range(7):
                        if ins.preferenze[i*7+j] != "":
                            print(getStringsFromDayHour(i,j)[0] + " " + getStringsFromDayHour(i,j)[1] + ": " + ins.preferenze[i*7+j])
          
    def merge(self):
        '''Più Insegnamenti potrebbero contenere le preferenze dello stesso Docente'''
        self.sort()
        listRes:List[InsegnamentoJotForm] = list()
        indexRes = 0
        for ins in self.listIns:
            if indexRes > 0 and listRes[indexRes-1].titolare == ins.titolare:
                # merge
                for i in range(5):
                    for j in range(7):
                        if listRes[indexRes-1].preferenze[i*7+j] == ins.preferenze[i*7+j]:
                            # già salvata
                            pass
                        if listRes[indexRes-1].preferenze[i*7+j] == "" and ins.preferenze[i*7+j] != "":
                            listRes[indexRes-1].preferenze[i*7+j] = ins.preferenze[i*7+j]
                        if listRes[indexRes-1].preferenze[i*7+j] == "Non Gradito" and listRes[indexRes-1].preferenze[i*7+j] == "Indisponibile":
                            listRes[indexRes-1].preferenze[i*7+j] = "Indisponibile"
            else:
                # add
                listRes.append(ins)
                indexRes += 1
        self.listIns = listRes
                
    def writeJsonStyle(self):
        f = open("like_json.json", "w")
        for ins in self.listIns:
            favorevole:List[str] = list()
            contrario:List[str] = list()
            nonGradito:List[str] = list()
            
            if ins.checkStrange():
                for i in range(5):
                    for j in range(7):
                        slot = ins.preferenze[i*7+j]         
                        (day,fascia) = getStringsFromDayHour(i,j)
                        if slot == "Indisponibile":# and len(contrario) < 5:
                            contrario.append('\"' + day + '_' + fascia + '_LVH\"')
                        # elif slot == "Non Gradito":# and len(nonGradito) < 5:
                        #     nonGradito.append('\"' + day + '_' + fascia + '_LV3\"')
                        # elif slot == "Gradito":
                        #     favorevole.append('\"' + day + '_' + fascia + '_LV3\"')
                contrario.extend(nonGradito)
            else:
                for i in range(5):
                    for j in range(7):
                        slot = ins.preferenze[i*7+j]         
                        (day,fascia) = getStringsFromDayHour(i,j)
                        if slot == "Indisponibile":
                            contrario.append('\"' + day + '_' + fascia + '_LVH\"')
                        # elif slot == "Non Gradito":
                        #     nonGradito.append('\"' + day + '_' + fascia + '_LV3\"')
                        # elif slot == "Gradito":
                        #     favorevole.append('\"' + day + '_' + fascia + '_LV3\"')
                contrario.extend(nonGradito)
            # output
            if len(contrario) == 0 and len(favorevole) == 0:
                continue
            f.write('\"' + ins.titolare + '\": {\n')
            if len(favorevole) > 0:
                f.write("\"favorevole\": {\n")
                first = True
                for slot in favorevole:
                    if not first:
                        f.write(",\n")
                    first = False
                    f.write(slot + ': \"ugualeA\"')
                f.write("\n}")
                if len(contrario) > 0:
                    f.write(",\n")
            if len(contrario) > 0:
                f.write("\"contrario\": {\n")
                first = True
                for slot in contrario:
                    if not first:
                      f.write(",\n")
                    first = False
                    f.write(slot + ': \"ugualeA\"')
                f.write("\n}")
            
            f.write("\n},")
            
        f.close()
                            
            